/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart;

import java.net.URL;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.ChartPanelElement;
import org.simantics.jfreechart.internal.Activator;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.utils.datastructures.Pair;

public class ChartPanelHeader
extends Composite {
    public static int HEADER_MINIMUM_WIDTH = 250;
    private ChartPanelElement element;
    private Resource resource;
    private LocalResourceManager rm;
    private Label name;
    private Canvas iconCanvas;
    private Image icon;
    private ToolItem minimize;
    private ToolItem remove;
    private Color defaultColor;
    private Color darker;
    private Color evenDarker;
    private Image gradientBackgroundImage;
    private Image borderImage;
    private static ImageDescriptor closeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/close.gif"));
    private static ImageDescriptor minimizeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/minimize.gif"));
    private static ImageDescriptor maximizeDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/maximize.gif"));
    private static ImageDescriptor lineChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_line_light.png"));
    private static ImageDescriptor barChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_bar_light.png"));
    private static ImageDescriptor pieChartDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/chart_pie_light.png"));
    private Image closeImage;
    private Image minimizeImage;
    private Image maximizeImage;
    private Image lineChartImage;
    private Image barChartImage;
    private Image pieChartImage;
    private DragSourceListener dragSourceListener;
    private DragSource source;

    public ChartPanelHeader(Composite c, ChartPanelElement element, Resource chartResource, int style) {
        super(c, style);
        this.resource = chartResource;
        this.element = element;
        this.rm = new LocalResourceManager(JFaceResources.getResources(), (Control)c);
        this.createColors((ResourceManager)this.rm);
        this.createImages((ResourceManager)this.rm);
        GridLayoutFactory.fillDefaults().margins(3, 0).numColumns(3).applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        this.iconCanvas = new Canvas((Composite)this, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(16, 16).applyTo((Control)this.iconCanvas);
        this.iconCanvas.addPaintListener(e -> {
            if (this.icon != null) {
                e.gc.drawImage(this.icon, 0, 0);
            }
        });
        this.name = new Label((Composite)this, 0);
        try {
            Pair result = (Pair)Simantics.getSession().syncRequest((Read)new Read<Pair<String, Image>>(){

                public Pair<String, Image> perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    String label = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)ChartPanelHeader.this.resource);
                    Image image = null;
                    Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(ChartPanelHeader.this.resource, l0.ConsistsOf, jfree.Plot));
                    if (plot != null) {
                        image = graph.isInstanceOf(plot, jfree.CategoryPlot) ? ChartPanelHeader.this.barChartImage : (graph.isInstanceOf(plot, jfree.PiePlot) ? ChartPanelHeader.this.pieChartImage : ChartPanelHeader.this.lineChartImage);
                    }
                    return new Pair((Object)label, image);
                }
            }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<Pair<String, Image>>(){

                public void execute(final Pair<String, Image> result) {
                    if (result == null) {
                        return;
                    }
                    ChartPanelHeader.this.name.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).ChartPanelHeader.this.name.isDisposed() && result.first != null) {
                                (this).ChartPanelHeader.this.name.setText((String)result.first);
                            }
                            if (!(this).ChartPanelHeader.this.iconCanvas.isDisposed() && result.second != null) {
                                (this).ChartPanelHeader.this.icon = (Image)result.second;
                                (this).ChartPanelHeader.this.iconCanvas.redraw();
                                ChartPanelHeader.this.layout();
                            }
                        }
                    });
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    return ChartPanelHeader.this.name.isDisposed();
                }
            });
            this.name.setText((String)result.first);
        }
        catch (DatabaseException e2) {
            e2.printStackTrace();
            this.name.setText("No label");
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name);
        ToolBar toolbar = new ToolBar((Composite)this, 0x800000);
        this.minimize = new ToolItem(toolbar, 8);
        this.minimize.addSelectionListener((SelectionListener)new MinimizeListener());
        if (this.isMinimized()) {
            this.minimize.setToolTipText("Expand");
            this.minimize.setImage(this.maximizeImage);
        } else {
            this.minimize.setToolTipText("Minimize");
            this.minimize.setImage(this.minimizeImage);
        }
        this.remove = new ToolItem(toolbar, 8);
        this.remove.setImage(this.closeImage);
        this.remove.addSelectionListener((SelectionListener)new RemoveChartListener());
        this.remove.setToolTipText("Remove");
        int operations = 2;
        this.source = new DragSource((Control)this.name, operations);
        Transfer[] types = new Transfer[]{LocalObjectTransfer.getTransfer()};
        this.source.setTransfer(types);
        this.dragSourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (ChartPanelHeader.this.name.isDisposed()) {
                    event.doit = false;
                }
                event.detail = 4;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = new StructuredSelection((Object)ChartPanelHeader.this.resource);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.source.addDragListener(this.dragSourceListener);
        this.name.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChartPanelHeader.this.dragSourceListener != null && ChartPanelHeader.this.source != null && !ChartPanelHeader.this.source.isDisposed()) {
                    ChartPanelHeader.this.source.removeDragListener(ChartPanelHeader.this.dragSourceListener);
                }
            }
        });
        this.gradientBackgroundImage = this.getGradientBackgroundImage();
        this.setBackgroundImage(this.gradientBackgroundImage);
        this.setBackgroundMode(2);
        this.addListener(6, new EnterListener());
        this.addListener(7, new ExitListener());
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.addListener(6, (Listener)new EnterListener());
            child.addListener(7, (Listener)new ExitListener());
            ++n2;
        }
        this.addDisposeListener(e -> {
            if (this.gradientBackgroundImage != null) {
                this.gradientBackgroundImage.dispose();
            }
            if (this.borderImage != null) {
                this.borderImage.dispose();
            }
        });
    }

    private void createImages(ResourceManager rm) {
        this.closeImage = (Image)rm.get((DeviceResourceDescriptor)closeDescriptor);
        this.minimizeImage = (Image)rm.get((DeviceResourceDescriptor)minimizeDescriptor);
        this.maximizeImage = (Image)rm.get((DeviceResourceDescriptor)maximizeDescriptor);
        this.lineChartImage = (Image)rm.get((DeviceResourceDescriptor)lineChartDescriptor);
        this.barChartImage = (Image)rm.get((DeviceResourceDescriptor)barChartDescriptor);
        this.pieChartImage = (Image)rm.get((DeviceResourceDescriptor)pieChartDescriptor);
    }

    private void createColors(ResourceManager rm) {
        Display d = this.getDisplay();
        this.defaultColor = d.getSystemColor(22);
        int r = this.defaultColor.getRed();
        int g = this.defaultColor.getGreen();
        int b = this.defaultColor.getBlue();
        try {
            this.darker = new Color((Device)d, r - 30, g - 30, b - 30);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.darker = this.defaultColor;
        }
        try {
            this.evenDarker = new Color((Device)d, r - 50, g - 50, b - 50);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.evenDarker = this.defaultColor;
        }
    }

    private Image createVerticalGradientImage(Color fg, Color bg, int h) {
        Image img = new Image((Device)this.getDisplay(), 1, h);
        GC gc = new GC((Drawable)img);
        gc.setForeground(fg);
        gc.setBackground(bg);
        gc.fillGradientRectangle(0, 0, 1, h, true);
        gc.dispose();
        return img;
    }

    private Image getHighlightedGradientBackgroundImage() {
        this.layout();
        Point size = this.getSize();
        return this.createVerticalGradientImage(this.defaultColor, this.evenDarker, Math.max(1, size.y));
    }

    private Image getGradientBackgroundImage() {
        this.layout();
        Point size = this.computeSize(-1, -1);
        return this.createVerticalGradientImage(this.defaultColor, this.darker, Math.max(1, size.y));
    }

    private boolean isMinimized() {
        return this.element.isMinimized();
    }

    private class EnterListener
    implements Listener {
        private EnterListener() {
        }

        public void handleEvent(Event event) {
            Image oldImg = ChartPanelHeader.this.borderImage;
            ChartPanelHeader.this.borderImage = ChartPanelHeader.this.getHighlightedGradientBackgroundImage();
            ChartPanelHeader.this.setBackgroundImage(ChartPanelHeader.this.borderImage);
            if (oldImg != null) {
                oldImg.dispose();
            }
        }
    }

    private class ExitListener
    implements Listener {
        private ExitListener() {
        }

        public void handleEvent(Event event) {
            Image oldImg = ChartPanelHeader.this.gradientBackgroundImage;
            ChartPanelHeader.this.gradientBackgroundImage = ChartPanelHeader.this.getGradientBackgroundImage();
            ChartPanelHeader.this.setBackgroundImage(ChartPanelHeader.this.gradientBackgroundImage);
            if (oldImg != null) {
                oldImg.dispose();
            }
        }
    }

    private class MinimizeListener
    implements SelectionListener {
        private MinimizeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ChartPanelHeader.this.isDisposed()) {
                return;
            }
            ChartPanelHeader.this.element.toggleMinimize(true);
            if (!ChartPanelHeader.this.name.isDisposed() && !ChartPanelHeader.this.minimize.isDisposed()) {
                if (ChartPanelHeader.this.isMinimized()) {
                    ChartPanelHeader.this.minimize.setToolTipText("Expand");
                } else {
                    ChartPanelHeader.this.minimize.setToolTipText("Minimize");
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class RemoveChartListener
    implements SelectionListener {
        private RemoveChartListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!ChartPanelHeader.this.isDisposed()) {
                ChartPanelHeader.this.element.remove();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

