/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties.bar;

import java.util.Collection;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.ChartPropertyOptions;
import org.simantics.jfreechart.chart.properties.ChartVariable;
import org.simantics.jfreechart.chart.properties.ChartVariableFactory;
import org.simantics.jfreechart.chart.properties.ChartVariableModifier;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.jfreechart.chart.properties.RangeComposite;
import org.simantics.jfreechart.chart.properties.StringChooser;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Composite for modifying properties of a series in a bar chart
 * @author Teemu Lempinen
 *
 */
public class BarSeriesPropertyComposite2 extends Composite {
    
    private TrackedText label, time;
    private StringChooser<ChartVariable> variable;
    
    public BarSeriesPropertyComposite2(Composite parent, final ISessionContext context, WidgetSupport support, Collection<ChartVariable> variables, int options, int style) {
        super(parent, style);
        
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this);

        // Variable for the series
        Label label = new Label(this, SWT.NONE);
        label.setText("Variable:");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.FILL).applyTo(label);

//        variable = new TrackedText(this, support, SWT.BORDER);
//       
//    	// FIXME: using bijectionmap and trackedText looses the variables that have the same label.
//    	BijectionMap<String , String> map = new BijectionMap<String, String>();
//    	for (ChartVariable variable : variables) {
//			map.map(variable.getRvi(), variable.toString());
//		}
//    	variable.setTextFactory(new VariableFactory(map));
//    	variable.addModifyListener(new VariableModifier(variable.getWidget(), support));
//    	variable.setInputValidator(new VariableExistsValidator(support, variable, false, true));
       

        variable = new StringChooser<ChartVariable>(this, support, SWT.BORDER);
        variable.setData(variables);
        variable.setObjectFactory(new ChartVariableFactory(variables));
        variable.addModifyListener(new ChartVariableModifier(variable.getWidget(), support));
        
        variable.setColorProvider(new JFreeChartPropertyColorProvider(this.variable.getResourceManager()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.variable.getWidget());

        // Range
        label = new Label(this, SWT.NONE);
        label.setText("Range:");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.CENTER).applyTo(label);
        
        RangeComposite rangeComposite = new RangeComposite(this, context, support, SWT.NONE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(rangeComposite);
        
        
        // Label to be displayed in chart for this series
        label = new Label(this, SWT.NONE);
        label.setText("Label:");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.FILL).applyTo(label);

        this.label = new TrackedText(this, support, SWT.BORDER);
        this.label.setTextFactory(new StringPropertyFactory(Layer0.URIs.HasLabel, ""));
        this.label.addModifyListener(new StringPropertyModifier(context, Layer0.URIs.HasLabel));
        this.label.setColorProvider(new JFreeChartPropertyColorProvider(this.label.getResourceManager()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.label.getWidget());
        
        if ((options & ChartPropertyOptions.SHOW_TIME) > 0) {
	        // Time
	        label = new Label(this, SWT.NONE);
	        GridDataFactory.fillDefaults().align(SWT.END, SWT.FILL).applyTo(label);
	        label.setText("Time:");
	        
	        Composite composite = new Composite(this, SWT.NONE);
	        GridDataFactory.fillDefaults().applyTo(composite);
	        GridLayoutFactory.fillDefaults().applyTo(composite);
	        
	        time = new org.simantics.browsing.ui.swt.widgets.TrackedText(composite, support, SWT.BORDER);
	        time.setTextFactory(new DoublePropertyFactory(JFreeChartResource.URIs.Series_time));
	        time.addModifyListener(new DoublePropertyModifier(context, JFreeChartResource.URIs.Series_time));
	        time.setInputValidator(new DoubleValidator(true));
	        time.setColorProvider(new JFreeChartPropertyColorProvider(time.getResourceManager()));
	        GridDataFactory.fillDefaults().applyTo(time.getWidget());
        }
    }
    
    @Override
    public void dispose() {
    	variable.dispose();
    	variable = null;
    	super.dispose();
    }
}
