/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * TitleModifier for chart title
 * @author Teemu Lempinen
 *
 */
public class TitleModifier extends TextModifyListenerImpl<Resource> {

    @Override
    public void applyText(WriteGraph graph, Resource chart, String text) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        Resource title = graph.syncRequest(new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.TextTitle));
        if(title == null) {
            title = GraphUtils.create2(graph, jfree.TextTitle,
                    jfree.Title_position, jfree.Top);
        }
        graph.claimLiteral(title, l0.HasLabel, text);
    }

}