/*******************************************************************************
 * Copyright (c) 2007, 2025 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import java.awt.BasicStroke;

import org.jfree.chart.LegendItem;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.renderer.xy.SamplingXYLineRenderer;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * Renderer representing jfree chart renderer for xy lines
 * @author Teemu Lempinen
 */
public class XYLineRenderer extends AbstractRenderer {

    SamplingXYLineRenderer renderer;

    public XYLineRenderer(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    @Override
    public org.jfree.chart.renderer.AbstractRenderer getRenderer() {
        if(renderer == null) {
            // Fixing a problem with JFreeChart's SamplingXYLineRenderer:
            // Its implementation does not override getLegendItem and the base implementation
            // in AbstractXYItemRenderer sets a zero-width BasicStroke the legend items
            // it constructs. Therefore the line-based legend items will be quite invisible
            // by default.
            // A better visibility solution for the problem is to force getTreatLegendShapeAsLine
            // to return false to get square blocks in the legend which are better visible
            // than even a thicker line.
            BasicStroke thickStroke = new BasicStroke(2.0f);
            renderer = new SamplingXYLineRenderer() {
                @Override
                public LegendItem getLegendItem(int datasetIndex, int series) {
                    var s = super.getLegendItem(datasetIndex, series);
                    s.setLineStroke(thickStroke);
                    return s;
                }
                @Override
                protected boolean getTreatLegendShapeAsLine() {
                    return false;
                }
            };
            renderer.setDefaultToolTipGenerator(new StandardXYToolTipGenerator());
        }
        return renderer;
    }

}
