/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Referable;

public class WeightedMedian2 {
    public int maxItems;
    public int itemCount;
    @Optional
    public Item median;
    public double rpos;

    public WeightedMedian2() {
        this.maxItems = Integer.MAX_VALUE;
    }

    public WeightedMedian2(int maxItems) {
        this.maxItems = maxItems;
    }

    public void clear() {
        this.itemCount = 0;
        this.median = null;
        this.rpos = 0.0;
    }

    public void add(double weight, double value) {
        if (weight <= 0.0) {
            return;
        }
        if (this.median == null) {
            this.median = new Item(weight, value);
            ++this.itemCount;
            this.rpos = weight / 2.0;
            return;
        }
        Item i = this.median;
        while (true) {
            if (value >= i.low && value <= i.high) {
                double totWeight = i.weight + weight;
                i.value = (i.value * i.weight + value * weight) / totWeight;
                i.weight = totWeight;
                break;
            }
            if (value < i.low) {
                if (i.prev == null) {
                    i.prev = new Item(weight, value, null, i);
                    ++this.itemCount;
                    break;
                }
                if (i.prev.high < value) {
                    Item n = new Item(weight, value, i.prev, i);
                    ++this.itemCount;
                    i.prev.next = n;
                    i.prev = n;
                    break;
                }
                i = i.prev;
                continue;
            }
            if (!(value > i.high)) continue;
            if (i.next == null) {
                i.next = new Item(weight, value, i, null);
                ++this.itemCount;
                break;
            }
            if (i.next.low > value) {
                Item n = new Item(weight, value, i, i.next);
                ++this.itemCount;
                i.next.prev = n;
                i.next = n;
                break;
            }
            i = i.next;
        }
        this.rpos += (double)(value < this.median.low ? -1 : 1) * weight / 2.0;
        while (this.rpos < 0.0) {
            this.median = this.median.prev;
            this.rpos += this.median.weight;
        }
        while (this.rpos >= this.median.weight) {
            this.rpos -= this.median.weight;
            this.median = this.median.next;
        }
        if (this.itemCount > this.maxItems) {
            this.coalesce();
        }
    }

    public void coalesce() {
        double totWeight;
        Item i = this.median.next;
        while (i != null) {
            Item n = i.next;
            if (n == null) break;
            i.next = n.next;
            if (n.next != null) {
                n.next.prev = i;
            }
            totWeight = i.weight + n.weight;
            i.high = n.high;
            i.value = (i.value * i.weight + n.value * n.weight) / totWeight;
            i.weight = totWeight;
            i = i.next;
        }
        i = this.median.prev;
        while (i != null) {
            Item p = i.prev;
            if (p == null) break;
            i.prev = p.prev;
            if (p.prev != null) {
                p.prev.next = i;
            }
            totWeight = i.weight + p.weight;
            i.low = p.low;
            i.value = (i.value * i.weight + p.value * p.weight) / totWeight;
            i.weight = totWeight;
            i = i.prev;
        }
    }

    public double getMedian() {
        if (this.median == null) {
            return Double.NaN;
        }
        if (this.median.low == this.median.high) {
            return this.median.value;
        }
        double d = this.median.high - this.median.low;
        double r = this.rpos / this.median.weight;
        return this.median.low + d * r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Median=" + this.getMedian() + " ");
        Item i = this.first();
        while (i != null) {
            sb.append("(");
            sb.append("value=");
            if (i.low == i.high) {
                sb.append(i.value);
            } else {
                sb.append(i.value + " (" + i.low + ".." + i.high + ")");
            }
            sb.append(", w=" + i.weight);
            if (i == this.median) {
                sb.append(", pos=" + this.rpos);
            }
            sb.append(")");
            i = i.next;
        }
        return sb.toString();
    }

    Item first() {
        if (this.median == null) {
            return null;
        }
        Item i = this.median;
        while (i.prev != null) {
            i = i.prev;
        }
        return i;
    }

    @Referable
    public static class Item {
        public double weight;
        public double low;
        public double high;
        public double value;
        @Optional
        public Item prev;
        @Optional
        public Item next;

        public Item() {
        }

        public Item(double weight, double value) {
            this.weight = weight;
            this.low = this.high = value;
        }

        public Item(double weight, double value, Item prev, Item next) {
            this.weight = weight;
            this.low = this.high = value;
            this.value = this.high;
            this.prev = prev;
            this.next = next;
        }

        public String toString() {
            if (this.low == this.high) {
                return "(value=" + this.value + ", w=" + this.weight + ")";
            }
            return "(value=" + this.value + " (" + this.low + ".." + this.high + "), w=" + this.weight + ")";
        }
    }
}

