/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;

public class Median<T> {
    PriorityQueue<T> upper;
    PriorityQueue<T> lower;
    T median;

    public Median(Comparator<? super T> comparator) {
        this.lower = new PriorityQueue<T>(11, comparator);
        this.upper = new PriorityQueue<T>(11, Collections.reverseOrder(comparator));
    }

    public Median(int length, Comparator<? super T> comparator) {
        int c = length / 2;
        if (c < 3) {
            c = 3;
        }
        this.lower = new PriorityQueue<T>(c, comparator);
        this.upper = new PriorityQueue<T>(c, Collections.reverseOrder(comparator));
    }

    public void clear() {
        this.lower.clear();
        this.upper.clear();
        this.median = null;
    }

    public void add(T e) {
        if (this.median == null) {
            this.median = e;
            return;
        }
        int cmp = this.lower.comparator().compare(e, this.median);
        if (cmp < 0) {
            this.upper.add(e);
        } else {
            this.lower.add(e);
        }
        int diff = this.upper.size() - this.lower.size();
        if (diff >= 1) {
            this.lower.add(this.median);
            this.median = this.upper.remove();
        } else if (diff < -1) {
            this.upper.add(this.median);
            this.median = this.lower.remove();
        }
    }

    public T getMedian() {
        return this.median;
    }

    public int size() {
        return this.upper.size() + this.lower.size();
    }

    public void setSize(int newSize) {
        int i;
        int y;
        int x = newSize / 2;
        if (this.upper.size() < x) {
            this.upper.clear();
        } else {
            y = this.upper.size() - x;
            i = 0;
            while (i < y) {
                this.upper.remove();
                ++i;
            }
        }
        if (this.lower.size() < x) {
            this.lower.clear();
        } else {
            y = this.lower.size() - x;
            i = 0;
            while (i < y) {
                this.lower.remove();
                ++i;
            }
        }
    }
}

