/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.representation;

/**
 * A part of TransferableGraph data structure. 
 * Declares resource as a root resource with given name.
 * @author Hannu Niemist�
 */
public class Root implements IdentityDefinition {
	public String name;
	public String type;
	
	public Root() {		
	}

	public Root(String name, String type) {	
		this.name = name;
		this.type = type;
	}
	
	@Override
	public String toString() {
	    return "Root(" + name + ", " + type + ")";
	}
}
