/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.validation;

import java.util.Collection;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.TemplateDefinitionStore;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementCollision;

public class ReportCollisions
implements Runnable {
    GraphCompilerPreferences preferences;
    Collection<Problem> problems;
    GraphStore store;

    public ReportCollisions(GraphCompilerPreferences preferences, Collection<Problem> problems, GraphStore store) {
        this.preferences = preferences;
        this.problems = problems;
        this.store = store;
    }

    private static String abbreviateURI(Res res) {
        if (res == null) {
            return "null";
        }
        String uri = res.toString();
        return uri.replace("http://www.simantics.org/", "");
    }

    @Override
    public void run() {
        int c;
        LocationStore locations = (LocationStore)this.store.getStore(LocationStore.class);
        int[] nArray = this.store.values.getCollisions().toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.problems.add(new Problem(locations.getLocation(c), "Two literal values are given for the same resource."));
            ++n2;
        }
        nArray = this.store.identities.getCollisions().toArray();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.problems.add(new Problem(locations.getLocation(c), "Two different identities are given for the same resource."));
            ++n2;
        }
        nArray = ((TemplateDefinitionStore)this.store.getStore(TemplateDefinitionStore.class)).getCollisions().toArray();
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            c = nArray[n2];
            this.problems.add(new Problem(locations.getLocation(c), "Two template definitions are given for the same resource."));
            ++n2;
        }
        if (this.preferences.validate) {
            for (StatementCollision collision : this.store.statements.getCollisions()) {
                this.problems.add(new Problem(locations.getLocation(collision.subject), "The same statement is defined " + collision.count + " times: " + ReportCollisions.abbreviateURI(this.store.idToRes(collision.subject)) + ", " + ReportCollisions.abbreviateURI(this.store.idToRes(collision.predicate)) + ", " + ReportCollisions.abbreviateURI(this.store.idToRes(collision.object))));
            }
        }
    }
}

