/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.contribution;

import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.procedure.adapter.AsyncListenerAdapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.contribution.Messages;
import org.simantics.document.ui.contribution.NameInputValidator;
import org.simantics.document.ui.graphfile.DocumentVersionUtils;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.AbstractResourceTabContribution;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.selectionview.PropertyTabContributorImpl;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class DocumentTabContribution
extends AbstractResourceTabContribution {
    public DocumentTabContribution(ReadGraph graph, Resource r) throws DatabaseException {
        super(graph, r);
    }

    public void getContributors(ReadGraph graph, Resource resource, Integer priority, String label, Collection<ComparableTabContributor> result) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(resource, doc.Document)) {
            return;
        }
        result.add(new ComparableTabContributor((PropertyTabContributor)new DocumentPropertyTabContributor(), 1.0, (Object)resource, Messages.DocumentTabContribution_Document));
    }

    private static void openResource(final Resource resource) {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DocumentTabContribution.openResource(graph, resource);
            }
        });
    }

    private static void openResource(ReadGraph graph, final Resource resource) throws DatabaseException {
        EditorAdapter[] adapters = EditorRegistry.getInstance().getAdaptersFor(graph, (Object)resource);
        if (adapters.length == 0) {
            return;
        }
        EditorAdapter highPri = null;
        int pri = Integer.MIN_VALUE;
        EditorAdapter[] editorAdapterArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            EditorAdapter a = editorAdapterArray[n2];
            int p = a.getPriority();
            if (highPri == null || p > pri) {
                highPri = a;
                pri = p;
            }
            ++n2;
        }
        final EditorAdapter adapter = highPri;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    adapter.openEditor((Object)resource);
                }
                catch (Exception e) {
                    ExceptionUtils.logAndShowError((String)Messages.DocumentTabContribution_7, (Throwable)e);
                }
            }
        });
    }

    private class DocumentPropertyTabContributor
    extends PropertyTabContributorImpl {
        private DocumentPropertyTabContributor() {
        }

        public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, final WidgetSupport support) {
            Composite composite = new Composite(body, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            GridLayoutFactory.fillDefaults().margins(3, 3).spacing(1, 1).numColumns(4).applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.DocumentTabContribution_Name);
            TrackedText name = new TrackedText(composite, support, 2048);
            name.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasName"));
            name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
            NameInputValidator validator = new NameInputValidator();
            name.setInputValidator((IInputValidator)validator);
            support.register((Widget)validator);
            Button showButton = new Button(composite, 8);
            showButton.setText(Messages.DocumentTabContribution_Show);
            showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DocumentTabContribution.openResource((Resource)AdaptionUtils.adaptToSingle((Object)support.getInput(), Resource.class));
                }
            });
            try {
                DocumentResource doc = DocumentResource.getInstance((RequestProcessor)context.getSession());
                new DocumentRevisionWidget(composite, support, doc.HasOlderVersion, Messages.DocumentTabContribution_Old);
                new DocumentRevisionWidget(composite, support, doc.HasNewerVersion, Messages.DocumentTabContribution_New);
            }
            catch (DatabaseException e1) {
                ExceptionUtils.logAndShowError((String)Messages.DocumentTabContribution_CannotCreateDocumentVersionUI, (Throwable)e1);
            }
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)name.getWidget());
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)showButton);
        }

        public Read<String> getPartNameReadRequest(final ISelection forSelection) {
            return new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Resource res = (Resource)AdaptionUtils.adaptToSingle((Object)forSelection, Resource.class);
                    if (res == null) {
                        return Messages.DocumentTabContribution_6;
                    }
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    return (String)graph.getPossibleRelatedValue(res, l0.HasName);
                }
            };
        }
    }

    private static class DocumentRevisionWidget
    implements Widget {
        ISessionContext context;
        Resource document;
        Resource revisionRel;
        NamedResource revisionDoc;
        Button showButton;
        Button removeButton;
        Text text;

        public DocumentRevisionWidget(Composite parent, WidgetSupport support, Resource rel, String name) {
            support.register((Widget)this);
            this.revisionRel = rel;
            Label label = new Label(parent, 0);
            label.setText(name);
            this.text = new Text(parent, 2060);
            this.showButton = new Button(parent, 8);
            this.showButton.setText(Messages.DocumentTabContribution_8);
            this.showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (revisionDoc != null) {
                        DocumentTabContribution.openResource(revisionDoc.getResource());
                    }
                }
            });
            this.removeButton = new Button(parent, 8);
            this.removeButton.setText(Messages.DocumentTabContribution_9);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (revisionDoc == null) {
                        return;
                    }
                    try {
                        context.getSession().syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                DocumentVersionUtils.unsetVersion(graph, document, revisionDoc.getResource(), revisionRel);
                            }
                        });
                        revisionDoc = null;
                    }
                    catch (DatabaseException e1) {
                        ExceptionUtils.logAndShowError((String)Messages.DocumentTabContribution_10, (Throwable)e1);
                    }
                    this.updateUI();
                }
            });
            DropTarget dropTarget = new DropTarget((Control)this.text, 5);
            dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.getInstance(), LocalObjectTransfer.getTransfer()});
            dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                public void dragEnter(DropTargetEvent event) {
                    event.detail = 4;
                }

                public void drop(DropTargetEvent event) {
                    ResourceArray[] data = this.parseEventData(event);
                    if (data.length != 1) {
                        return;
                    }
                    if (data[0].resources == null || data[0].resources.length != 1) {
                        return;
                    }
                    this.setRevisionDoc(data[0].resources[0]);
                }

                private ResourceArray[] parseEventData(DropTargetEvent event) {
                    ResourceArray[] ret;
                    if (event.data instanceof String) {
                        try {
                            SerialisationSupport support = (SerialisationSupport)context.getSession().getService(SerialisationSupport.class);
                            return ResourceTransferUtils.readStringTransferable((SerialisationSupport)support, (String)((String)event.data)).toResourceArrayArray();
                        }
                        catch (IllegalArgumentException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                        catch (DatabaseException e) {
                            ErrorLogger.defaultLogError((Throwable)e);
                        }
                    }
                    if ((ret = ResourceAdaptionUtils.toResourceArrays((Object)event.data)).length > 0) {
                        return ret;
                    }
                    return null;
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.text);
        }

        public void setInput(ISessionContext context, Object input) {
            this.context = context;
            this.document = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
            context.getSession().asyncRequest((Read)new Read<NamedResource>(){

                public NamedResource perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource revisionDoc = graph.getPossibleObject(document, revisionRel);
                    if (revisionDoc == null) {
                        return null;
                    }
                    return new NamedResource((String)graph.getRelatedValue(revisionDoc, l0.HasName), revisionDoc);
                }
            }, (AsyncListener)new AsyncListenerAdapter<NamedResource>(){

                public void execute(AsyncReadGraph graph, final NamedResource result) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            revisionDoc = result;
                            this.updateUI();
                        }
                    });
                }

                public void exception(AsyncReadGraph graph, Throwable t) {
                    ExceptionUtils.logAndShowError((String)Messages.DocumentTabContribution_11, (Throwable)t);
                }

                public boolean isDisposed() {
                    return showButton.isDisposed();
                }
            });
            this.updateUI();
        }

        private void updateUI() {
            if (this.showButton.isDisposed()) {
                return;
            }
            this.showButton.setEnabled(this.revisionDoc != null);
            this.removeButton.setEnabled(this.revisionDoc != null);
            if (this.revisionDoc != null) {
                this.text.setText(this.revisionDoc.getName());
            } else {
                this.text.setText("");
            }
        }

        private void setRevisionDoc(final Resource toSet) {
            this.context.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DocumentVersionUtils.setVersion(graph, document, toSet, revisionRel);
                }
            });
        }
    }
}

