package org.simantics.document.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CSSCompletionAssistProcessor implements IContentAssistProcessor {
    
    private String lastError = ""; //$NON-NLS-1$
    private CSSTextEditorEnvironment environment;
    
    public CSSCompletionAssistProcessor(CSSTextEditorEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int tmpOffset) {
        ITextSelection selection= (ITextSelection) viewer.getSelectionProvider().getSelection();
        // adjust offset to end of normalized selection
        if (selection.getOffset() == tmpOffset)
            tmpOffset = selection.getOffset() + selection.getLength();
        final int offset = tmpOffset;
        IDocument document = viewer.getDocument();
        String tmpPrefix = ""; //$NON-NLS-1$
        try {
            tmpPrefix = getPrefix(document, offset);
        } catch (BadLocationException e) {
            e.printStackTrace();
        }
        environment.updateEnvironment(document);
        return environment.getCompletionProposals(tmpPrefix, offset);
    }
    
    private static String getPrefix(IDocument doc, int offset) throws BadLocationException {
        if (doc == null || offset >= doc.getLength())
            return ""; //$NON-NLS-1$

        int length= 0;
        while (--offset >= 0 && Character.isJavaIdentifierPart(doc.getChar(offset)) || doc.getChar(offset) == '.')
            length++;

        return doc.get(offset + 1, length);
    }
    
    @Override
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    private static final char[] AUTO_ACTIVATION_CHARS = new char[] { '.', '(' };
    
    @Override
    public char[] getCompletionProposalAutoActivationCharacters() {
        return AUTO_ACTIVATION_CHARS;
    }

    @Override
    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return lastError;
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

}
