/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.Functions;

public class DocumentPropertyKeys
extends ResourceRead<List<String>> {
    public DocumentPropertyKeys(Resource resource) {
        super(resource);
    }

    public List<String> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        try {
            if (graph.hasStatement(this.resource, DOC.Properties_dataDefinitions)) {
                result.add("dataDefinitions");
            }
        }
        catch (ServiceException e) {
            Functions.LOGGER.info(e.getMessage(), (Throwable)e);
        }
        for (Resource predicate : graph.getDirectPredicates(this.resource)) {
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
            if (info.isHasProperty && info.hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) {
                result.add(info.name);
                continue;
            }
            Resource definition = graph.getPossibleObject(predicate, DOC.Document_definesAttributeRelation);
            if (definition == null) continue;
            PropertyInfo info2 = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(definition));
            result.add(info2.name);
        }
        return result;
    }
}

