package org.simantics.document.server.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.DocumentServerUtils.AttributesRequest;
import org.simantics.document.server.JSONObject;

public class NodeRequest extends VariableRead<JSONObject> {

    public static final String ERRORS = "Errors";
    public static final String PROPERTY_VALUE_EXCEPTIONS = "_PropertyValueExceptions";

    public NodeRequest(Variable node) {
        super(node);
    }

    @Override
    public JSONObject perform(ReadGraph graph) throws DatabaseException {
        long s = DocumentRequest.PROFILE ? System.nanoTime() : 0L;

        JSONObject staticContent = graph.syncRequest(new AttributesRequest(variable));

        if (DocumentRequest.PROFILE) {
            long dura = System.nanoTime()-s;
            if (dura > DocumentRequest.PROFILE_THRESHOLD_NODEREQUEST * 1e3) {
                System.err.println("NodeRequest " + System.identityHashCode(this) + " in " + 1e-6*dura + "ms. " + variable.getURI(graph));
            }
        }

        return staticContent;
    }

}
