/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.client;

import java.util.HashSet;
import java.util.TreeMap;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.ICommand;

public class WidgetData {
	
	public Object widget;
	public JSONObject object;
	public Document document;
	public TreeMap<String, WidgetData> childmap = new TreeMap<String, WidgetData>(new AlphanumericComparator());
    public HashSet<Object> listenerRegistrations = new HashSet<Object>();

	public WidgetData(Document document, Object widget, JSONObject object) {
		this.widget = widget;
		this.object = object;
		this.document = document;
	}
	
	@SuppressWarnings({ "rawtypes" })
	public Object createElement() {
		if(object == null)
			return null;
		WidgetManager manager = document.getManager(object);
		return manager == null ? null : manager.createWidget(object);
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void updateChildren() {
		if(object != null && widget != null && childmap != null) {
			WidgetManager manager = document.getManager(object);
			if(manager != null)
				manager.updateChildren(document, object, widget, childmap);
		}
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void updateProperties() {
		if(object == null)
			return;
		WidgetManager manager = document.getManager(object);
		if(manager != null)
			manager.updateProperties(document, object, widget);		
	}
	
    @SuppressWarnings({ "rawtypes", "unchecked" })
    public void updateCommands() {
        if(object == null)
            return;
        
        // Then create the updated registrations
        CommandManager manager = document.getCommandManager(object); 
        
        // First remove all handler registrations
        if(manager != null) {
        	for(Object listener : listenerRegistrations) {
        		manager.removeListener(widget, listener);
        	}
        }
        listenerRegistrations.clear();
        if(manager != null)
            listenerRegistrations.addAll(manager.updateCommandListeners(document, object, widget));
        
    }
    
    @SuppressWarnings({ "unchecked", "rawtypes" })
    public IEventCommand eventCommand(ICommand command, CommandContext c) {
        if(object == null)
            return null;
        WidgetManager manager = document.getManager(object);
        if(manager != null)
            return manager.eventCommand(document, object, widget, command, c); 
        else
            return null;
    }
	
}
