/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import org.simantics.document.server.serverResponse.DelayedResponse;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;

/**
 * Listener for listening experiment stopped events. Listener removes itself 
 * when experiment has first been run and then stopped and notifies response.
 * 
 * @author Teemu Lempinen
 *
 */
public class ExperimentStoppedListener implements IExperimentListener {

    private boolean hasRun = false;
    private DelayedResponse response;
    private IExperiment experiment;

    public ExperimentStoppedListener(IExperiment experiment, DelayedResponse response) {
        this.experiment = experiment;
        this.response = response;
    }

    @Override
    public void stateChanged(ExperimentState state) {
        if(state.equals(ExperimentState.RUNNING))
            hasRun = true;

        if(state.equals(ExperimentState.STOPPED) && hasRun) {
            response.setHasRun();
            experiment.removeListener(this);
            synchronized(response) {
                response.notify();
            }
        }
    }
}
