/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * This interface abstracts the computation of document component properties.
 * The key,value -pairs returned by this interface are used to build the
 * org.simantics.document.server.JSONObject values used in the document
 * scene graph.
 *
 * @author Antti Villberg
 * @since 1.36.0
 */
public interface DocumentProperties {

    /*
     * Returns the set of attribute keys for the given document component.
     * Does not return null.
     */
    Collection<String> getKeys(ReadGraph graph, Variable component) throws DatabaseException;
    /*
     * Returns a value for a key in the key set.
     * Null values are allowed and normal DatabaseException
     * are thrown when evaluating the value.
     */
    Object getValue(ReadGraph graph, Variable component, String key) throws DatabaseException;

}
