/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.simantics.diagram.symbolcontribution.GroupProxySymbolItem;
import org.simantics.diagram.symbolcontribution.ModifiableSymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.utils.strings.AlphanumComparator;

public class CompositeSymbolGroup
extends ModifiableSymbolGroup {
    Collection<ISymbolGroup> groups = new ArrayList<ISymbolGroup>(4);

    public CompositeSymbolGroup(Object identification, String name, String description) {
        super(identification, name, description);
    }

    public void add(ISymbolGroup group) {
        this.groups.add(group);
    }

    public Collection<ISymbolGroup> getGroups() {
        return this.groups;
    }

    @Override
    public ISymbolItem[] getItems() {
        ArrayList<GroupProxySymbolItem> items = new ArrayList<GroupProxySymbolItem>();
        for (ISymbolGroup group : this.groups) {
            ISymbolItem[] iSymbolItemArray = group.getItems();
            int n = iSymbolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISymbolItem item = iSymbolItemArray[n2];
                items.add(new GroupProxySymbolItem(item, this));
                ++n2;
            }
        }
        Collections.sort(items, new Comparator<ISymbolItem>(){

            @Override
            public int compare(ISymbolItem o1, ISymbolItem o2) {
                return AlphanumComparator.COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
            }
        });
        return items.toArray(new ISymbolItem[items.size()]);
    }

    @Override
    public String toString() {
        return super.toString() + "[composed group count=" + this.groups.size() + "]";
    }
}

