/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.ElementSymbolItem;
import org.simantics.diagram.symbolcontribution.Hasher;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.ModifiableSymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolGroup;
import org.simantics.diagram.symbolcontribution.SymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactories;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;

public class BasicSymbolProviderFactory
implements SymbolProviderFactory {
    private final Resource contribution;
    private final Resource diagram;
    private byte[] contributionHash;
    private transient int hash;

    public BasicSymbolProviderFactory(ReadGraph graph, Resource contribution, Resource diagram) throws DatabaseException {
        this.contribution = contribution;
        this.diagram = diagram;
        this.contributionHash = (byte[])graph.syncRequest((Read)new LoadHashRequest(contribution, diagram));
    }

    private int hash() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.contribution);
        result = 31 * result + Arrays.hashCode(this.contributionHash);
        return result;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hash();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSymbolProviderFactory other = (BasicSymbolProviderFactory)obj;
        return Objects.equals(this.contribution, other.contribution) && Arrays.equals(this.contributionHash, other.contributionHash);
    }

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return (ISymbolProvider)g.syncRequest((Read)new LoadRequest(this.contribution, this.diagram));
    }

    static Hasher hashGroup(ReadGraph graph, Hasher hasher, Resource library, Resource relation, Resource diagram) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (!SymbolProviderFactories.accept(graph, DIA, library, diagram)) {
            return hasher;
        }
        hasher.update(library);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        for (Resource item : cs.asSortedList((Collection)graph.syncRequest((Read)new ObjectsWithSupertype(library, relation, DIA.Element)))) {
            if (!SymbolProviderFactories.accept(graph, DIA, item, diagram)) continue;
            hasher.update(item);
        }
        return hasher;
    }

    static SymbolGroup createGroup(ReadGraph graph, Resource library, Resource relation, Resource diagram) throws DatabaseException {
        Layer0 L0 = (Layer0)graph.l0();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String name = BasicSymbolProviderFactory.safeName(graph, library);
        String description = (String)graph.getPossibleRelatedValue2(library, L0.HasDescription, (Binding)Bindings.STRING);
        if (description == null) {
            description = name;
        }
        ModifiableSymbolGroup group = new ModifiableSymbolGroup((Object)library, name, description);
        ArrayList<ElementSymbolItem> items = new ArrayList<ElementSymbolItem>();
        for (Resource item : (Set)graph.syncRequest((Read)new ObjectsWithSupertype(library, relation, DIA.Element))) {
            if (!SymbolProviderFactories.accept(graph, DIA, item, diagram)) continue;
            String itemName = BasicSymbolProviderFactory.safeName(graph, item);
            String itemDescription = (String)graph.getPossibleRelatedValue2(item, L0.HasDescription, (Binding)Bindings.STRING);
            if (itemDescription == null || itemDescription.isEmpty()) {
                itemDescription = itemName;
            }
            items.add(new ElementSymbolItem(item, itemName, itemDescription, (ISymbolGroup)group));
        }
        Collections.sort(items, (o1, o2) -> AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName()));
        group.setItems(items.toArray(new ISymbolItem[items.size()]));
        return group;
    }

    private static String safeName(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = (Layer0)graph.l0();
        String name = (String)graph.getPossibleRelatedValue2(r, L0.HasLabel, (Binding)Bindings.STRING);
        if (name == null || name.isEmpty()) {
            name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        }
        if (name == null) {
            name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
        }
        return name;
    }

    static class LoadHashRequest
    extends BinaryRead<Resource, Resource, byte[]> {
        public LoadHashRequest(Resource contribution, Resource diagram) {
            super((Object)contribution, (Object)diagram);
        }

        public byte[] perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = (Layer0)graph.l0();
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            Hasher h = new Hasher();
            if (SymbolProviderFactories.accept(graph, DIA, (Resource)this.parameter, (Resource)this.parameter2)) {
                h.update((Resource)this.parameter);
                Instances query = (Instances)graph.adapt(DIA.SymbolReferenceLibrary, Instances.class);
                for (Resource library : cs.asSortedList(query.find(graph, (Resource)this.parameter))) {
                    BasicSymbolProviderFactory.hashGroup(graph, h, library, L0.DependsOn, (Resource)this.parameter2);
                }
            }
            return h.digest();
        }
    }

    static class LoadRequest
    extends BinaryRead<Resource, Resource, ISymbolProvider> {
        public LoadRequest(Resource contribution, Resource diagram) {
            super((Object)contribution, (Object)diagram);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            if (!SymbolProviderFactories.accept(graph, DIA, (Resource)this.parameter, (Resource)this.parameter2)) {
                return new SymbolProvider(Collections.emptyList());
            }
            Collection libraries = graph.getObjects((Resource)this.parameter, DIA.BasicSymbolContributionHasSymbolLibrary);
            ArrayList<ISymbolGroup> groups = new ArrayList<ISymbolGroup>(libraries.size());
            for (Resource library : libraries) {
                if (!SymbolProviderFactories.accept(graph, DIA, library, (Resource)this.parameter2)) continue;
                groups.add(BasicSymbolProviderFactory.createGroup(graph, library, L0.DependsOn, (Resource)this.parameter2));
            }
            return new SymbolProvider(groups);
        }
    }
}

