/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbolcontribution;

import org.eclipse.core.runtime.IAdaptable;

final class AdaptablePair<T1, T2>
implements IAdaptable {
    public final T1 first;
    public final T2 second;
    private final int hash;

    public static <T1, T2> AdaptablePair<T1, T2> make(T1 t1, T2 t2) {
        return new AdaptablePair<T1, T2>(t1, t2);
    }

    public AdaptablePair(T1 first, T2 second) {
        this.first = first;
        this.second = second;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AdaptablePair other = (AdaptablePair)obj;
        if (!(other.first == this.first || other.first != null && other.first.equals(this.first))) {
            return false;
        }
        return other.second == this.second || other.second != null && other.second.equals(this.second);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "<" + String.valueOf(this.first) + ", " + String.valueOf(this.second) + ">";
    }

    private int makeHash() {
        return (this.first == null ? 0 : this.first.hashCode()) + (this.second == null ? 0 : this.second.hashCode()) * 31;
    }

    private Object adapt(Object o, Class<?> clazz) {
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof IAdaptable) {
            return ((IAdaptable)o).getAdapter(clazz);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Object o = this.adapt(this.first, adapter);
        return o == null ? this.adapt(this.second, adapter) : o;
    }
}

