/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.GraphHints;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBaseData;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scenegraph.profile.common.ObserverGroupValueListener;
import org.simantics.scenegraph.profile.common.ProfileObserverData;
import org.simantics.scenegraph.profile.impl.DebugPolicy;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.utils.datastructures.Pair;

public abstract class StyleBase<Result>
implements Style {
    private Object identity;
    private double priority;

    public StyleBase(Object identity) {
        this.identity = identity;
    }

    public StyleBase() {
        this.identity = this.getClass();
    }

    protected <T> T getIdentity() {
        return (T)this.identity;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getPriority() {
        return this.priority;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleBase other = (StyleBase)obj;
        return !(this.identity == null ? other.identity != null : !this.identity.equals(other.identity));
    }

    protected Resource getResource() {
        return (Resource)this.getIdentity();
    }

    public Result calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        Variable activeVariable = (Variable)graph.syncRequest((Read)new RuntimeDiagramVariableRequest(runtimeDiagram), (Listener)TransientCacheListener.instance());
        if (activeVariable == null) {
            return null;
        }
        return this.calculateStyle(graph, runtimeDiagram, entry, groupItem, activeVariable);
    }

    public Result calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem, Variable activeComposite) throws DatabaseException {
        return null;
    }

    public void styleResultChanged(Observer observer, Resource runtimeDiagram, Resource object, Result result) {
        if (result == null) {
            ProfileObserverData.getInstance().removeValue((Tuple)new Tuple3((Object)this, (Object)runtimeDiagram, (Object)object));
        } else {
            ProfileObserverData.getInstance().putValue((Tuple)new Tuple3((Object)this, (Object)runtimeDiagram, (Object)object), result);
        }
        observer.update((Style)this, (Object)object);
    }

    public void applyStyleForNode(EvaluationContext evaluationContext, INode node, Result result) {
    }

    public void applyStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item, Result value) {
        INode node = map.getNode(item);
        if (node == null) {
            if (evaluationContext.isActive((Style)this, item)) {
                evaluationContext.update((Style)this, item);
            }
            return;
        }
        if (DebugPolicy.DEBUG_PROFILE_STYLE_APPLICATION) {
            System.out.println(String.valueOf(this) + ": applying style for item " + String.valueOf(item) + " and element " + String.valueOf(node) + " with result " + String.valueOf(value));
        }
        this.applyStyleForNode(evaluationContext, node, value);
    }

    protected void cleanupStyleForNode(INode node) {
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        this.cleanupStyleForNode(node);
    }

    protected void cleanupStyleForItem(EvaluationContext evaluationContext, DataNodeMap map, Object item) {
        INode node = map.getNode(item);
        if (node != null) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println(String.valueOf(this) + ".cleanupStyleForItem(" + String.valueOf(item) + " = " + String.valueOf(node) + ")");
            }
            this.cleanupStyleForNode(evaluationContext, node);
        }
    }

    public final void activate(RequestProcessor backend, Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) throws DatabaseException {
        GroupListener listener = this.getListener(runtimeDiagram, group);
        if (listener == null || listener.isDisposed()) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println("activate(" + String.valueOf(runtimeDiagram) + ", " + String.valueOf(group) + ", " + String.valueOf(observer));
            }
            listener = new GroupListener(backend.getSession(), runtimeDiagram, entry, this, group, (Observer)observer);
            ProfileObserverData.getInstance().putListener((Style)this, runtimeDiagram, group, listener);
            group.trackItems(backend, runtimeDiagram, listener);
        }
        listener.addEntry(entry);
    }

    protected Object getIdentity(Resource entry) {
        return new Pair(this.getClass(), (Object)entry);
    }

    protected Read<Result> getStyleCalculationRequest(Resource runtimeDiagram, final Resource entry, Resource item) {
        return new TernaryRead<Object, Resource, Resource, Result>(this.getIdentity(entry), runtimeDiagram, item){

            public Result perform(ReadGraph graph) throws DatabaseException {
                GraphHints old = graph.setHintValue("sync", (Object)false);
                try {
                    Object result = StyleBase.this.calculateStyle(graph, (Resource)this.parameter2, entry, (Resource)this.parameter3);
                    if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                        System.out.println(String.valueOf(StyleBase.this) + ": calculated style result for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)this.parameter3), (boolean)true) + ": " + String.valueOf(result));
                    }
                    Object Result = result;
                    return Result;
                }
                finally {
                    graph.setHints(old);
                }
            }
        };
    }

    protected Listener<Result> getStyleResultListener(ObserverGroupListener groupListener, final Resource item, Group group, Observer observer, final Resource runtimeDiagram) {
        return new ObserverGroupValueListener<Result>(groupListener, observer, group, item){

            public void execute(Result result) {
                if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                    System.out.println(String.valueOf(StyleBase.this) + ": style result changed for " + String.valueOf(item) + ": " + String.valueOf(result));
                }
                StyleBase.this.styleResultChanged(this.observer, runtimeDiagram, item, result);
            }
        };
    }

    public final void deactivate(Resource runtimeDiagram, Resource entry, Group group, EvaluationContext observer) {
        ObserverGroupListener listener = this.getListener(runtimeDiagram, group);
        if (listener != null) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                System.out.println("deactivate(" + String.valueOf(runtimeDiagram) + ", " + String.valueOf(group) + ", " + String.valueOf(observer));
            }
            IDiagram diagram = (IDiagram)observer.getConstant(ProfileKeys.DIAGRAM);
            listener.removeEntry(entry);
            if (!listener.hasEntries()) {
                listener.dispose();
                ProfileObserverData.getInstance().removeListener((Style)this, runtimeDiagram, group);
            }
            if (diagram != null) {
                this.cleanupItems(observer, diagram, listener.getItems().toArray());
                diagram = null;
            }
        }
    }

    public final void apply(Resource entry, Group group, EvaluationContext evaluationContext) {
        ICanvasContext context = (ICanvasContext)evaluationContext.getConstant(ProfileKeys.CANVAS);
        assert (context.getThreadAccess().currentThreadAccess());
        ObserverGroupListener listener = this.getListener(evaluationContext.getResource(), group);
        if (listener == null) {
            System.out.println(String.valueOf(this) + "(" + this.getClass().getSimpleName() + ") had no listener for " + String.valueOf(evaluationContext.getResource()) + " " + String.valueOf(group));
            return;
        }
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        if (DebugPolicy.DEBUG_PROFILE_STYLE_APPLICATION) {
            System.out.println(String.valueOf(this) + ": applying style for items: " + String.valueOf(listener.getItems()));
        }
        StyleBaseData styleBaseData = StyleBaseData.getInstance();
        styleBaseData.applyRemovals(evaluationContext, this);
        ProfileObserverData profileObserverData = ProfileObserverData.getInstance();
        IDiagram diagram = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
        assert (diagram != null);
        DataElementMap emap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        for (Object item : listener.getItems()) {
            Object value = profileObserverData.getValue((Tuple)new Tuple3((Object)this, (Object)evaluationContext.getResource(), item));
            this.applyStyleForItem(evaluationContext, map, item, value);
            IElement element = emap.getElement(diagram, item);
            if (element == null) continue;
            element.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
        }
    }

    public final void apply2(Object item, EvaluationContext evaluationContext) {
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        StyleBaseData styleBaseData = StyleBaseData.getInstance();
        styleBaseData.applyRemovals(evaluationContext, this);
        ProfileObserverData profileObserverData = ProfileObserverData.getInstance();
        Object value = profileObserverData.getValue((Tuple)new Tuple3((Object)this, (Object)evaluationContext.getResource(), item));
        this.applyStyleForItem(evaluationContext, map, item, value);
        IDiagram diagram = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
        assert (diagram != null);
        DataElementMap emap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        IElement element = emap.getElement(diagram, item);
        if (element != null) {
            element.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
        }
    }

    protected final void cleanupItems(final EvaluationContext evaluationContext, final IDiagram diagram, final Object[] items) {
        ICanvasContext context = (ICanvasContext)evaluationContext.getConstant(ProfileKeys.CANVAS);
        context.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (evaluationContext.isDisposed()) {
                    return;
                }
                DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
                if (DebugPolicy.DEBUG_PROFILE_STYLE_ACTIVATION) {
                    System.out.println(String.valueOf(this) + ".cleanupItems(" + String.valueOf(evaluationContext) + ", " + String.valueOf(diagram) + ", " + Arrays.toString(items));
                }
                IDiagram diagram2 = (IDiagram)evaluationContext.getConstant(ProfileKeys.DIAGRAM);
                if (!$assertionsDisabled && diagram2 == null) {
                    throw new AssertionError();
                }
                DataElementMap emap = (DataElementMap)diagram2.getDiagramClass().getSingleItem(DataElementMap.class);
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    StyleBase.this.cleanupStyleForItem(evaluationContext, map, item);
                    IElement element = emap.getElement(diagram2, item);
                    if (element != null) {
                        element.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
                    }
                    ++n2;
                }
            }
        });
    }

    private ObserverGroupListener getListener(Resource runtime, Group group) {
        return ProfileObserverData.getInstance().getListener((Style)this, runtime, group);
    }

    static class GroupListener<T>
    extends ObserverGroupListener {
        private StyleBase<T> style;
        private Session session;
        private Resource runtimeDiagram;
        private Resource entry;

        GroupListener(Session session, Resource runtimeDiagram, Resource entry, StyleBase<T> style, Group group, Observer observer) {
            super(style, group, observer);
            this.style = style;
            this.session = session;
            this.runtimeDiagram = runtimeDiagram;
            this.entry = entry;
        }

        public void add(Resource item) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                System.out.println(String.valueOf(this.style) + ": added to group " + String.valueOf(this.group) + ": " + String.valueOf(item));
            }
            this.session.asyncRequest(this.style.getStyleCalculationRequest(this.runtimeDiagram, this.entry, item), this.style.getStyleResultListener(this, item, this.group, this.observer, this.runtimeDiagram));
            super.add(item);
        }

        public void remove(Resource item) {
            if (DebugPolicy.DEBUG_PROFILE_STYLE_GROUP_TRACKING) {
                System.out.println(String.valueOf(this.style) + ": removed from group " + String.valueOf(this.group) + ": " + String.valueOf(item));
            }
            StyleBaseData.getInstance().removeItem(this.style, item);
            super.remove(item);
        }
    }

    static class RuntimeDiagramVariableRequest
    extends UnaryRead<Resource, Variable> {
        public RuntimeDiagramVariableRequest(Resource runtimeDiagram) {
            super((Object)runtimeDiagram);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            String variableURI = (String)graph.getPossibleRelatedValue((Resource)this.parameter, DIA.RuntimeDiagram_HasVariable, (Binding)Bindings.STRING);
            if (variableURI == null) {
                return null;
            }
            Variable activeVariable = Variables.getPossibleVariable((ReadGraph)graph, (String)variableURI);
            return activeVariable;
        }
    }
}

