/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.AdaptionUtils;

public class ConnectionCrossingMenuContribution
extends DynamicMenuContribution {
    private static final IContributionItem EMPTY_ITEM = new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem crossings = new MenuItem(menu, 64, index);
            crossings.setText("Connection Crossings");
            Menu crossingsMenu = new Menu(menu);
            crossings.setMenu(crossingsMenu);
            crossingsMenu.setEnabled(false);
            crossings.setEnabled(false);
        }
    };
    private static final IContributionItem[] NO_ITEMS = new IContributionItem[]{EMPTY_ITEM};

    private static List<Resource> getDiagramForSelection(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        ArrayDeque<Resource> stack = new ArrayDeque<Resource>();
        if (r != null) {
            stack.push(r);
        }
        while (!stack.isEmpty()) {
            r = (Resource)stack.pop();
            if (graph.isInstanceOf(r, DIA.Diagram)) {
                result.add(r);
                continue;
            }
            if (graph.isInstanceOf(r, STR.Composite)) {
                Resource diagram = graph.getPossibleObject(r, MOD.CompositeToDiagram);
                if (diagram != null) {
                    result.add(diagram);
                    continue;
                }
                stack.addAll(graph.getObjects(r, L0.ConsistsOf));
                continue;
            }
            if (!graph.isInstanceOf(r, L0.Library)) continue;
            stack.addAll(graph.getObjects(r, L0.ConsistsOf));
        }
        return result;
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        Object diags;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> diagrams = new ArrayList<Resource>();
        if (selection.length >= 1) {
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                Resource r = (Resource)AdaptionUtils.adaptToSingle((Object)sel, Resource.class);
                if (r == null) {
                    return NO_ITEMS;
                }
                diags = ConnectionCrossingMenuContribution.getDiagramForSelection(graph, r);
                if (diags.size() == 0) {
                    return NO_ITEMS;
                }
                diagrams.addAll((Collection<Resource>)diags);
                ++n2;
            }
        }
        if (diagrams.size() == 0) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IEditorPart editorPart = null;
            if (window != null) {
                editorPart = window.getActivePage().getActiveEditor();
            } else {
                diags = PlatformUI.getWorkbench().getWorkbenchWindows();
                int r = ((IWorkbenchWindow[])diags).length;
                int n = 0;
                while (n < r) {
                    IWorkbenchWindow w = diags[n];
                    if (w.getActivePage() != null && (editorPart = w.getActivePage().getActiveEditor()) != null) break;
                    ++n;
                }
            }
            if (editorPart == null) {
                return NO_ITEMS;
            }
            IEditorInput input = editorPart.getEditorInput();
            if (!(input instanceof IResourceEditorInput)) {
                return NO_ITEMS;
            }
            Resource diagram = ((IResourceEditorInput)input).getResource();
            if (diagram != null) {
                diagrams.add(diagram);
            }
        }
        if (diagrams.size() == 0) {
            return NO_ITEMS;
        }
        HashMap<Resource, Integer> currentTypes = new HashMap<Resource, Integer>();
        ArrayList<Object> currentWidths = new ArrayList<Object>();
        for (Resource diagram : diagrams) {
            Resource currentType = graph.getPossibleObject(diagram, DIA.ConnectionCrossingStyle_HasType);
            if (currentType == null) continue;
            Integer c = (Integer)currentTypes.get(currentType);
            c = c == null ? Integer.valueOf(1) : Integer.valueOf(c + 1);
            currentTypes.put(currentType, c);
            Double width = (Double)graph.getPossibleRelatedValue(diagram, DIA.ConnectionCrossingStyle_Width, (Binding)Bindings.DOUBLE);
            if (width == null) continue;
            currentWidths.add(width);
        }
        if (currentTypes.size() == 0) {
            return NO_ITEMS;
        }
        Resource currentType = null;
        Double currentWidth = null;
        int wc = 0;
        for (Map.Entry e : currentTypes.entrySet()) {
            if (wc >= (Integer)e.getValue()) continue;
            wc = (Integer)e.getValue();
            currentType = (Resource)e.getKey();
        }
        if (currentWidths.size() != 0) {
            if (currentWidths.size() == 1) {
                currentWidth = (Double)currentWidths.get(0);
            } else {
                Collections.sort(currentWidths);
                int mid = currentWidths.size() / 2;
                currentWidth = (Double)currentWidths.get(mid);
            }
        }
        ArrayList<Resource> crossingTypes = new ArrayList<Resource>(4);
        crossingTypes.add(DIA.ConnectionCrossingStyle_Type_None);
        crossingTypes.add(DIA.ConnectionCrossingStyle_Type_Arc);
        crossingTypes.add(DIA.ConnectionCrossingStyle_Type_Gap);
        crossingTypes.add(DIA.ConnectionCrossingStyle_Type_Square);
        final ArrayList<Action> actions = new ArrayList<Action>(crossingTypes.size() + 2);
        for (Resource ct : crossingTypes) {
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)ct);
            SetCrossingTypeAction act = new SetCrossingTypeAction(name, diagrams, ct);
            actions.add(act);
            if (!ct.equals(currentType)) continue;
            act.setChecked(true);
        }
        if (currentWidth != null) {
            double nw;
            if (currentWidth > 0.0) {
                double nw2 = currentWidth - 0.5;
                if (nw2 < 0.0) {
                    nw2 = 0.0;
                }
                actions.add(new SetCrossingWidthAction(diagrams, nw2, false));
            }
            if ((nw = currentWidth + 0.5) > 0.0) {
                actions.add(new SetCrossingWidthAction(diagrams, nw, false));
            }
            actions.add(new SetCrossingWidthAction(diagrams, currentWidth, true));
        } else {
            actions.add(new SetCrossingWidthAction(diagrams, 1.0, true));
        }
        return new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem crossings = new MenuItem(menu, 64, index);
                crossings.setText("Connection Crossings");
                Menu crossingsMenu = new Menu(menu);
                crossings.setMenu(crossingsMenu);
                int i = 0;
                for (IAction act : actions) {
                    ActionContributionItem item = new ActionContributionItem(act);
                    item.fill(crossingsMenu, i);
                    ++i;
                }
            }
        }};
    }

    private static class SetCrossingTypeAction
    extends Action {
        private List<Resource> diagrams;
        private Resource crossingType;

        public SetCrossingTypeAction(String text, List<Resource> diagrams, Resource crossingType) {
            super(text, 8);
            this.diagrams = diagrams;
            this.crossingType = crossingType;
        }

        public void run() {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    for (Resource diagram : diagrams) {
                        graph.deny(diagram, DIA.ConnectionCrossingStyle_HasType);
                        graph.claim(diagram, DIA.ConnectionCrossingStyle_HasType, crossingType);
                    }
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Set crossing type to " + this.getText()));
                    graph.markUndoPoint();
                }
            });
        }
    }

    private static class SetCrossingWidthAction
    extends Action {
        private List<Resource> diagrams;
        private Double width;
        private Double currentWidth;

        public SetCrossingWidthAction(List<Resource> diagrams, double width, boolean current) {
            super((String)(current ? "Set width... " : "Set width " + width), 1);
            this.diagrams = diagrams;
            if (current) {
                this.currentWidth = width;
            } else {
                this.width = width;
            }
        }

        public void run() {
            if (this.width == null) {
                IInputValidator validator = new IInputValidator(){

                    public String isValid(String newText) {
                        try {
                            double d = Double.parseDouble(newText);
                            if (d < 0.0) {
                                return "Value must be positive.";
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return "Input is not a number.";
                        }
                        return null;
                    }
                };
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Diagram", "Set crossing width", this.currentWidth.toString(), validator);
                if (dialog.open() != 0) {
                    return;
                }
                this.width = Double.parseDouble(dialog.getValue());
            }
            if (this.width == null) {
                return;
            }
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    for (Resource diagram : diagrams) {
                        graph.deny(diagram, DIA.ConnectionCrossingStyle_Width);
                        graph.claimLiteral(diagram, DIA.ConnectionCrossingStyle_Width, (Object)width, (Binding)Bindings.DOUBLE);
                    }
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Set crossing width");
                    graph.markUndoPoint();
                }
            });
        }
    }
}

