/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.flag.IOTableInfo;
import org.simantics.diagram.flag.IOTablesInfo;
import org.simantics.diagram.function.All;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

public class IOTableUtil {
    public static IOTablesInfo getIOTablesInfo(ReadGraph graph, Resource diagram) throws DatabaseException {
        return (IOTablesInfo)graph.syncRequest((Read)new ResourceRead<IOTablesInfo>(diagram){

            public IOTablesInfo perform(ReadGraph graph) throws DatabaseException {
                Resource template = All.getTemplateFromDiagram(graph, this.resource);
                if (template == null) {
                    return IOTablesInfo.EMPTY;
                }
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                IOTablesInfo result = new IOTablesInfo();
                Collection slotTables = graph.getObjects(template, L0.ConsistsOf);
                for (Resource slotTable : slotTables) {
                    String name;
                    if (!graph.isInstanceOf(slotTable, TEMPLATE2D.FlagTable) || (name = (String)graph.getPossibleRelatedValue(slotTable, L0.HasName, (Binding)Bindings.STRING)) == null) continue;
                    Float width = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasWidth, (Binding)Bindings.FLOAT);
                    Float rowHeight = (Float)graph.getPossibleRelatedValue(slotTable, TEMPLATE2D.FlagTable_HasRowHeigth, (Binding)Bindings.FLOAT);
                    double[] transform = (double[])graph.getPossibleRelatedValue2(slotTable, DIA.Scenegraph_Composite_transform, Bindings.getBindingUnchecked(double[].class));
                    if (width == null || rowHeight == null || transform == null) continue;
                    result.tables.add(new IOTableInfo(name, transform[4], transform[5], width.floatValue(), rowHeight.floatValue()));
                }
                return result;
            }
        });
    }

    public static boolean bindFlagToTable(WriteGraph graph, Resource diagram, Resource flagResource, double flagX, double flagY) throws DatabaseException {
        IOTablesInfo ioTablesInfo = IOTableUtil.getIOTablesInfo((ReadGraph)graph, diagram);
        return ioTablesInfo.updateBinding(graph, DiagramResource.getInstance((ReadGraph)graph), flagResource, flagX, flagY);
    }
}

