/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.ConnectionInfo;
import org.simantics.diagram.connection.ConnectionSegmentEnd;
import org.simantics.diagram.connection.ConnectionSegmentType;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.stubs.DiagramResource;

public class ConnectionInfoRequest
extends UnaryAsyncRead<EdgeResource, ConnectionInfo> {
    final DiagramResource dr;
    private SingleConnectionInfo first;
    private SingleConnectionInfo second;

    public ConnectionInfoRequest(DiagramResource dr, EdgeResource resource) {
        super((Object)resource);
        this.dr = dr;
    }

    public void fillPossibleType(AsyncReadGraph graph, Resource resource, final AsyncProcedure<ConnectionInfo> procedure, final ConnectionInfo result) {
        if (resource == null) {
            procedure.execute(graph, (Object)result);
        } else {
            graph.forSingleType(resource, this.dr.Connection, (AsyncProcedure)new AsyncProcedure<Resource>(){

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    procedure.exception(graph, throwable);
                }

                public void execute(AsyncReadGraph graph, Resource type) {
                    result.connectionType = type;
                    procedure.execute(graph, (Object)result);
                }
            });
        }
    }

    ConnectionInfo createConnectionInfo(Resource connection) {
        ConnectionInfo info = new ConnectionInfo();
        info.connection = connection;
        info.firstEnd = this.first.end;
        info.secondEnd = this.second.end;
        info.segmentType = ConnectionSegmentType.toSegmentType(this.first.end, this.second.end);
        return info;
    }

    public void isBranchPointOf(AsyncReadGraph graph, Resource resource, final AsyncProcedure<ConnectionInfo> procedure, final SingleConnectionInfo result, final AtomicInteger ready) {
        graph.forPossibleObject(resource, this.dr.IsBranchPointOf, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Resource connection) {
                result.end = ConnectionSegmentEnd.BRANCH;
                result.connection = connection;
                if (ready.decrementAndGet() == 0) {
                    ConnectionInfo info = ConnectionInfoRequest.this.createConnectionInfo(connection);
                    ConnectionInfoRequest.this.fillPossibleType(graph, connection, (AsyncProcedure<ConnectionInfo>)procedure, info);
                }
            }
        });
    }

    public void isConnectorOf(AsyncReadGraph graph, final Resource resource, final AsyncProcedure<ConnectionInfo> procedure, final SingleConnectionInfo result, final AtomicInteger ready) {
        graph.forPossibleObject(resource, this.dr.IsConnectorOf, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Resource connection) {
                if (connection != null) {
                    result.end = ConnectionSegmentEnd.CONNECTOR;
                    result.connection = connection;
                    if (ready.decrementAndGet() == 0) {
                        ConnectionInfo info = ConnectionInfoRequest.this.createConnectionInfo(connection);
                        ConnectionInfoRequest.this.fillPossibleType(graph, connection, (AsyncProcedure<ConnectionInfo>)procedure, info);
                    }
                } else {
                    ConnectionInfoRequest.this.isBranchPointOf(graph, resource, (AsyncProcedure<ConnectionInfo>)procedure, result, ready);
                }
            }
        });
    }

    public void perform(AsyncReadGraph graph, AsyncProcedure<ConnectionInfo> procedure) {
        AtomicInteger ready = new AtomicInteger(2);
        this.first = new SingleConnectionInfo();
        this.second = new SingleConnectionInfo();
        this.isConnectorOf(graph, ((EdgeResource)this.parameter).first(), procedure, this.first, ready);
        this.isConnectorOf(graph, ((EdgeResource)this.parameter).second(), procedure, this.second, ready);
    }

    static class SingleConnectionInfo {
        public Resource connection;
        public ConnectionSegmentEnd end;

        SingleConnectionInfo() {
        }
    }
}

