/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IModelingRules;

/**
 * @author Tuukka Lehtonen
 */
public class SetConnectionType extends ModificationAdapter {

    ISynchronizationContext context;
    IDiagram                diagram;
    IElement                element;

    public SetConnectionType(ISynchronizationContext context, IDiagram diagram, IElement element) {
        super(SET_CONNECTION_TYPE_PRIORITY);
        this.context = context;
        this.diagram = diagram;
        this.element = element;
    }

    Resource getDesiredConnectionType(IElement e) {
        Object obj = e.getHint(ElementHints.KEY_CONNECTION_TYPE);
        if (obj instanceof Resource)
            return (Resource) obj;
        if (obj instanceof ConnectionJudgement) {
            ConnectionJudgement judgement = (ConnectionJudgement) obj;
            return judgement.connectionType;
        }
        return null;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        DiagramMutator mutator = diagram.getHint(DiagramHints.KEY_MUTATOR);
        IModelingRules modelingRules = diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);

        Resource connection = mutator.backendObject(element);
        Resource connectionType = getDesiredConnectionType(element);

        if (connectionType != null && modelingRules != null) {
            modelingRules.setConnectionType(graph, connection, connectionType);
        }
    }

}
