/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.BranchPoint.Direction;

/**
 * @author Tuukka Lehtonen
 */
public class AddBranchpoint extends ModificationAdapter {

    IDiagram diagram;
    IElement connection;
    IElement element;

    public AddBranchpoint(IDiagram diagram, IElement connection, IElement element) {
        super(ADD_BRANCH_PRIORITY);
        this.diagram = diagram;
        this.connection = connection;
        this.element = element;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        ConnectionUtil cu = new ConnectionUtil(g);

        DiagramMutator mutator = diagram.getHint(DiagramHints.KEY_MUTATOR);

        Resource connectionResource = mutator.backendObject(connection);

        AffineTransform tr = ElementUtils.getTransform(element);
        Direction dir = element.getElementClass().getSingleItem(BranchPoint.class).getDirectionPreference(element, null);
        Resource bp = cu.newBranchPoint(connectionResource, tr, dir);

        element.setHint(ElementHints.KEY_OBJECT, bp);
        mutator.register(element, bp);
    }

}
