/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.layer;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class LayersView extends PageBookView implements ISelectionProvider, ISelectionChangedListener {

	/**
	 * The plugin prefix.
	 */
	public static final String PREFIX = PlatformUI.PLUGIN_ID + "."; //$NON-NLS-1$

	/**
	 * Help context id used for the content outline view
	 * (value <code>"org.eclipse.ui.content_outline_context"</code>).
	 */
	public static final String LAYERS_VIEW_HELP_CONTEXT_ID = PREFIX	+ "layers_context";//$NON-NLS-1$

	/**
	 * Message to show on the default page.
	 */
	private String defaultText = Messages.LayersView_noLayers; 

	/**
	 * Creates a content outline view with no content outline pages.
	 */
	public LayersView() {
		super();
	}

	/* (non-Javadoc)
	 * Method declared on ISelectionProvider.
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		getSelectionProvider().addSelectionChangedListener(listener);
	}

	/* (non-Javadoc)
	 * Method declared on PageBookView.
	 */
	protected IPage createDefaultPage(PageBook book) {
		MessagePage page = new MessagePage();
		initPage(page);
		page.createControl(book);
		page.setMessage(defaultText);
		return page;
	}

	/**
	 * The <code>PageBookView</code> implementation of this <code>IWorkbenchPart</code>
	 * method creates a <code>PageBook</code> control with its default page showing.
	 */
	public void createPartControl(Composite parent) {
		super.createPartControl(parent);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(getPageBook(),
				LAYERS_VIEW_HELP_CONTEXT_ID);
	}

	/* (non-Javadoc)
	 * Method declared on PageBookView.
	 */
	protected PageRec doCreatePage(IWorkbenchPart part) {
		// Try to get an outline page.
		ILayersViewPage page = (ILayersViewPage)part.getAdapter(ILayersViewPage.class);
		if (page != null) {
			if (page instanceof IPageBookViewPage) {
				initPage((IPageBookViewPage) page);
			}
			page.createControl(getPageBook());
			return new PageRec(part, page);
		}
		// There is no content outline
		return null;
	}

	/* (non-Javadoc)
	 * Method declared on PageBookView.
	 */
	protected void doDestroyPage(IWorkbenchPart part, PageRec rec) {
		ILayersViewPage page = (ILayersViewPage) rec.page;
		page.dispose();
		rec.dispose();
	}

	/* (non-Javadoc)
	 * Method declared on IAdaptable.
	 */
	@SuppressWarnings("rawtypes")
    public Object getAdapter(Class key) {
		if (key == IContributedContentsView.class) {
			return new IContributedContentsView() {
				public IWorkbenchPart getContributingPart() {
					return getContributingEditor();
				}
			};
		}
		return super.getAdapter(key);
	}

	/* (non-Javadoc)
	 * Method declared on PageBookView.
	 */
	protected IWorkbenchPart getBootstrapPart() {
		IWorkbenchPage page = getSite().getPage();
		if (page != null) {
			return page.getActiveEditor();
		}

		return null;
	}

	/**
	 * Returns the editor which contributed the current 
	 * page to this view.
	 *
	 * @return the editor which contributed the current page
	 * or <code>null</code> if no editor contributed the current page
	 */
	private IWorkbenchPart getContributingEditor() {
		return getCurrentContributingPart();
	}

	/* (non-Javadoc)
	 * Method declared on ISelectionProvider.
	 */
	public ISelection getSelection() {
		// get the selection from the selection provider
		return getSelectionProvider().getSelection();
	}

	/* (non-Javadoc)
	 * Method declared on PageBookView.
	 * We only want to track editors.
	 */
	protected boolean isImportant(IWorkbenchPart part) {
		//We only care about editors
		return (part instanceof IEditorPart);
	}

	/* (non-Javadoc)
	 * Method declared on IViewPart.
	 * Treat this the same as part activation.
	 */
	public void partBroughtToTop(IWorkbenchPart part) {
		partActivated(part);
	}
	
    // Dirty hack to ensure that a new Page will be created if the previous one has been disposed due to disposal of AWTChassis 
    protected PageRec getPageRec(IWorkbenchPart part) {
        PageRec rec = super.getPageRec(part);
        if (rec == null || rec.page == null || rec.page.getControl() == null || rec.page.getControl().isDisposed()) 
            return null;
        else
            return rec;
    }

	/* (non-Javadoc)
	 * Method declared on ISelectionProvider.
	 */
	public void removeSelectionChangedListener(
			ISelectionChangedListener listener) {
		getSelectionProvider().removeSelectionChangedListener(listener);
	}

	/* (non-Javadoc)
	 * Method declared on ISelectionChangedListener.
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		getSelectionProvider().selectionChanged(event);
	}

	/* (non-Javadoc)
	 * Method declared on ISelectionProvider.
	 */
	public void setSelection(ISelection selection) {
		getSelectionProvider().setSelection(selection);
	}

	/**
	 * The <code>ContentOutline</code> implementation of this <code>PageBookView</code> method
	 * extends the behavior of its parent to use the current page as a selection provider.
	 * 
	 * @param pageRec the page record containing the page to show
	 */
	protected void showPageRec(PageRec pageRec) {
		IPageSite pageSite = getPageSite(pageRec.page);
		ISelectionProvider provider = pageSite.getSelectionProvider();
		if (provider == null && (pageRec.page instanceof ILayersViewPage)) {
			// This means that the page did not set a provider during its initialization 
			// so for backward compatibility we will set the page itself as the provider.
			pageSite.setSelectionProvider((ILayersViewPage) pageRec.page);
		}
		super.showPageRec(pageRec);
	}
}
