/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.diagram.G2DUtils;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementHints.Properties;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.PlainElementPropertySetter;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public class ElementPropertySetter extends PlainElementPropertySetter {

    private static final long serialVersionUID = 712071316674596405L;

    public static final ElementPropertySetter INSTANCE = new ElementPropertySetter(ElementHints.KEY_SG_NODE);

    public ElementPropertySetter(Key key) {
        super(key);
    }

    /**
     * Load default properties from graph. This is called by class factory, hence not defined in the interface
     * 
     * @param element
     * @param r
     * @param g
     */
    public void loadProperties(IElement element, Resource r, ReadGraph g) {
        Properties properties = new Properties();
        Layer0 L0 = Layer0.getInstance(g);
        try {
            // This way asserts do work:
            for (Resource predicate : g.getPredicates(r)) {
                if (g.isSubrelationOf(predicate, L0.HasProperty)) {
                    try {
                        String name = g.adapt(predicate, String.class);
                        Resource o = g.getPossibleObject(r, predicate);
                        if(o != null) { // FIXME: there should always be an object..
                            Object val = G2DUtils.getObject(g, o);
//                            System.out.println(name+" = "+val);
                            properties.put(name, val);
                        }
                    } catch (AdaptionException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    } catch (ValidationException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    } catch (NoSingleResultException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    } catch (DoesNotContainValueException e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            }
        } catch (ServiceException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        element.setHint(ElementHints.KEY_ELEMENT_PROPERTIES, properties);
    }
}
