package org.simantics.diagram.commandlog;

import java.awt.geom.AffineTransform;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.utils.commandlog.Command;

public class AddElementCommand implements Command {
	public final Resource diagram;
	public final Resource element;
	public final Resource elementType;
	public final String elementName;
	public final AffineTransform transform;

	public Resource composite;
	public Resource component;
	public String componentName;
	public Resource componentType;
	public String componentTypeName;

	public AddElementCommand(Resource diagram, Resource element, Resource elementType, String elementName,
			AffineTransform transform) {
		super();
		this.diagram = diagram;
		this.element = element;
		this.elementType = elementType;
		this.elementName = elementName;
		this.transform = transform;
	}

	@Override
	public void waitCompleted() throws Exception {
		Simantics.getSession().getService(ServiceActivityMonitor.class).waitForCompletion();

		Simantics.getSession().syncRequest(new ReadRequest() {
			@Override
			public void run(ReadGraph graph) throws DatabaseException {
				Layer0 L0 = Layer0.getInstance(graph);
				ModelingResources MOD = ModelingResources.getInstance(graph);
				
				composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite);
				component = graph.getPossibleObject(element, MOD.ElementToComponent);
				if(component != null) {
					componentName = graph.getPossibleRelatedValue(component, L0.HasName);
					componentType = graph.getPossibleObject(component, L0.InstanceOf);
					if(componentType != null)
						componentTypeName = graph.getPossibleRelatedValue(componentType, L0.HasName);
				}
			}
		});
	}
}
