/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.Session;
import org.simantics.db.event.ChangeListener;

/**
 * A listener added to a Session for receiving notifications for completed
 * write transactions.
 * 
 * @see GraphChangeEvent
 * @see Session
 */
public interface GraphChangeListenerSupport {

    void addListener(ChangeListener l);
    void removeListener(ChangeListener l);
    
    void addMetadataListener(ChangeListener l);
    void removeMetadataListener(ChangeListener l);

}
