package org.simantics.db.service;

import java.io.IOException;

import org.simantics.db.IO;

public interface ClusterSetsSupport {

	void connect(String databaseId);
	boolean containsKey(long resourceId);
	Long get(Long id);
	Long getSet(long clusterId);
	void setActiveCluster(long clusterSetResourceId, long clusterId);
	void setImmutability(long clusterSetResourceId, boolean immutable);
	void save() throws IOException;
	void clear();
	void setReadIO(IO read);
	void updateWriteIO(IO write);
	void validate(long[] ids);

}
