/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.request;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;

public interface QueryDeserializer {
	
	int readLE4();
	byte readByte();
	String readString();
	byte[] readByteArray();
	QueryFactory readFactory();
	Resource readResource() throws DatabaseException;
	Statement readStatement() throws DatabaseException;
	<K,V> void store(K key, V value);
	<K> void parent(K key);
	
}
