/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.request;

import org.simantics.db.service.ClusteringSupport;

public interface PersistentRead<T> extends Read<T> {
	void serializeKey(QuerySerializer serializer);
	void serializeValue(QuerySerializer serializer, T value);
	long cacheId(ClusteringSupport support);
	QueryFactoryKey classId();
}
