package org.simantics.db;

import org.simantics.databoard.Bindings;
import org.simantics.utils.Development;

public class DevelopmentKeys {

	final public static boolean EVERYTHING = false;
	
    final public static boolean  VERBOSE = false;

	final public static String PRINT = "Development.print";

	final public static String LOGGER_ECHO = trickToInitialize();
	
	final public static String WRITEGRAPH_DEBUG = "WriteGraph.debug";
	final public static String WRITEGRAPH_DEBUG_NAMES = "WriteGraph.debugNames";
	final public static String WRITEGRAPH_DEBUG_STACK = "WriteGraph.debugStack";

	final public static String WRITEGRAPH_EXCEPTION_STACKTRACES = "WriteGraph.exceptionStacktraces";
	
	final public static String WRITELOGGER_LOG = "WriteLogger.log";

	final public static String QUERYPROCESSOR_RECOMPUTE = "QueryProcessor.recompute";

	final public static String QUERYPROCESSOR_PERFORM_REQUEST = "QueryProcessor.performRequest";

	final public static String QUERYPROCESSOR_PERFORM_QUERY = "QueryProcessor.performQuery";

	final public static String QUERYPROCESSOR_LISTENERS = "QueryProcessor.listeners";

	final public static String QUERYPROCESSOR_CHANGES = "QueryProcessor.changes";

	final public static String QUERYPROCESSOR_UPDATE = "QueryProcessor.update";

	final public static String QUERYPROCESSOR_DEPENDENCIES = "QueryProcessor.dependencies";

	final public static String QUERYPROCESSOR_PUT = "QueryProcessor.put";

	final public static String QUERYCOLLECTOR = "QueryCollector";

	final public static String SESSION_LOG_WRITES = "Session.logWrites";

	final public static String READGRAPH_COUNT = "ReadGraph.count";

	final public static String CHANGESET_VALIDATION = "ChangeSetValidator.enabled";

	final public static String L0_VALIDATION = "L0.validation";

	final public static String CACHE_ENTRY_STATE = "CacheEntry.state";

	final public static String CLUSTERTABLE_VALIDATE_ON_LOAD = "ClusterTable.validateOnLoad";

	public static void initialize() {

		if(Development.DEVELOPMENT) {

			Development.setProperty(DevelopmentKeys.PRINT, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.LOGGER_ECHO, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG, EVERYTHING | false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_NAMES, EVERYTHING | false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_STACK, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITEGRAPH_EXCEPTION_STACKTRACES, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.READGRAPH_COUNT, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.CHANGESET_VALIDATION, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.L0_VALIDATION, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.CACHE_ENTRY_STATE, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITELOGGER_LOG, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_PERFORM_REQUEST, EVERYTHING | true, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_PERFORM_QUERY, EVERYTHING | true, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_RECOMPUTE, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_LISTENERS, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_CHANGES, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_UPDATE, EVERYTHING | true, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_DEPENDENCIES, EVERYTHING | false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_PUT, EVERYTHING |  false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYCOLLECTOR, EVERYTHING |  false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.SESSION_LOG_WRITES, EVERYTHING | false, Bindings.BOOLEAN);
			
			Development.setProperty(DevelopmentKeys.CLUSTERTABLE_VALIDATE_ON_LOAD, EVERYTHING | false, Bindings.BOOLEAN);
			
			

		}

	}
	// This enables to call initialize even if bundle activator is not yet called.
	// This happens when calling from headless junit4 plugin driver and ProCoreServer process does not start.  
	private static String trickToInitialize() {
        return "Logger.echo"; 
	}
	static {
        initialize();
	}
}
