/*******************************************************************************
 * Copyright (c) 2007, 2025 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.simantics.databoard.serialization.Sized;

public class ValueStream extends InputStream implements Sized {
	final private InputStream is;
	final private int amountOfBytes;
	public ValueStream(InputStream is, int amountOfBytes) {
		this.is = is;
		this.amountOfBytes = amountOfBytes;
	}
	public ValueStream(byte[] bytes) {
		this(new ByteArrayInputStream(bytes), bytes.length);
	}
	@Override
	public int getAmountOfBytes() {
		return amountOfBytes;
	}
	@Override
	public int read() throws IOException {
		return is.read();
	}
}
