/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import java.util.Collection;
import java.util.List;

import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.ConflictException;
import org.simantics.db.exception.DatabaseException;

public interface UndoRedoSupport {

    Operation getCurrent();

    /**
     * @param operations
     * @return Operation generated by the undo operation.
     * 
     * @throws DatabaseException
     * @throws ConflictException
     */
    Operation undo(Collection<Operation> operations)
    throws DatabaseException, ConflictException;

    /**
     * This is just a wrapper for the undo operation above. See documentation above
     * 
     * @param op the operation that will be undone.
     * @throws DatabaseException
     * @throws ConflictException
     */
    void undo(Operation op)
    throws DatabaseException, ConflictException;

    /**
     * Undo first count operations from the session undo list.
     * 
     * @param count number of operations to revert and move to sessions redo list.
     * @return Number of changes sets reverted.
     * @throws DatabaseException
     * @throws ConflictException
     */
    int undo(Session session, int count)
    throws DatabaseException;
    
    List<Operation> undoAndReturnOperations(Session session, int count)
    throws DatabaseException;   
    
    List<Operation> redo(Session session, int count)
    throws DatabaseException;

    int undoTo(Session session, long changeSet)
    throws DatabaseException;

    int initUndoListFrom(Session session, long changeSet)
    throws DatabaseException;

    /**
     * @return undo context used by given session. If session does not support
     *         undo or session is disposed, <code>null</code> will be returned.
     */
    UndoContext getUndoContext(Session session);

    interface ChangeListener {
        /**
         * Called when undo/redo lists change. 
         */
        void onChanged();
    }
    void subscribe(ChangeListener changeListener);
    void cancel(ChangeListener changeListener);
    
    void addExternalOperation(WriteGraph graph, ExternalOperation op);
    
}
