/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;



public interface TransactionPolicySupport {
    
    /**
     * Called when read transaction ends to decide if client should release
     * the transaction. 
     * 
     * @return true if you want to keep the transaction. 
     */
    boolean holdOnToTransactionAfterRead();

    /**
     * Called when transaction is cancelled to decide if client should release
     * the transaction.
     * 
     * @return true if you want to keep the transaction. 
     */
    boolean holdOnToTransactionAfterCancel();

    /**
     * Called when write transaction ends to decided if client should release
     * the transaction. 
     * 
     * @return true if you want to keep the transaction. 
     */
    boolean holdOnToTransactionAfterCommit();

    /**
     * Called when server asks us to relinquish the transaction. This should
     * trigger the end of ongoing requests. The caller (and server) will wait
     * until the requests are ended and the transaction is freed. You have to
     * end the requests during the call. If you do then onRelinquishDone is
     * called and you can ask for a transaction again. If you do not then the
     * connection is closed and all uncommitted work is lost. After connection
     * is closed onRelinquishError is called giving you a chance to clean up the
     * mess.
     */
    void onRelinquish();

    /**
     * Called after server has been sent the reply to relinquish message. This
     * means that you can ask transaction again.
     */
    void onRelinquishDone();

    /**
     * Called after onRelinquish has failed to end requests. This means that the
     * connection has been closed and all uncommitted work has been lost.
     */
    void onRelinquishError();
}
