/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.Resource;
import org.simantics.db.Statement;

public interface StatementSupport {
	Statement build(Resource s, Resource p, Resource o);
	boolean subjectEquals(Statement stm, Resource r);
	boolean predicateEquals(Statement stm, Resource r);
	boolean objectEquals(Statement stm, Resource r);
	boolean subjectAsserted(Statement stm);
	boolean predicateAsserted(Statement stm);
	boolean objectAsserted(Statement stm);
	boolean subjectPersistent(Statement stm);
	boolean predicatePersistent(Statement stm);
	boolean objectPersistent(Statement stm);
	boolean isList(Statement stm);
	boolean isTag(Statement stm);
}
