/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.Resource;
import org.simantics.db.ResourceSerializer;
import org.simantics.db.exception.DatabaseException;

public interface SerialisationSupport {

    /**
     * Get a ResourceSerializer for this session which can be used to
     * serialize Resource instances to string and back.
     */
    ResourceSerializer getResourceSerializer();

    Resource getResource(long randomAccessId) throws DatabaseException;
    Resource getResource(int transientId) throws DatabaseException;
    
    int getTransientId(Resource resource) throws DatabaseException;
    long getRandomAccessId(Resource resource) throws DatabaseException;
    
    int getTransientId(long randomAccessId) throws DatabaseException;
    long getRandomAccessId(int transientId) throws DatabaseException;
    
    ResourceUID getUID(Resource resource) throws DatabaseException;
    Resource getResource(ResourceUID uid) throws DatabaseException;
        
}
