/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.exception.DatabaseException;

public interface LifecycleSupport {

	public enum LifecycleState {
		CREATING, ALIVE, CLOSING, CLOSED
	}
	
	public interface LifecycleListener {
		void stateChanged(LifecycleState newState);
	}
	
    /**
     * Get session reference
     * @return session reference
     */
    SessionReference getSessionReference();

    /**
     * @return the SessionManager that created this Session.
     */
    SessionManager getSessionManager();

    /**
     * @return <code>true</code> if session is closed and thus no longer usable
     */
    boolean isClosing();
    boolean isClosed();
    
    void addListener(LifecycleListener listener);
    void removeListener(LifecycleListener listener);

    /**
     * Close this database session.
     * This should also dispose any Disposable services registered
     * into this ServiceLocator.
     * 
     * @param timeout maximum time to wait for prerequisites for close to become true.
     * If negative waits indefinitely. If zero polls. Time is given in milliseconds.
     * @param force If true close session after timeout even if transactions are still active.
     * If false throws TimeoutException if transactions are still active.
     * @throws DatabaseException
     */
    void close(long timeout, boolean force)
    throws DatabaseException;

    /**
     * Same as close(0, false).
     */
    void close()
    throws DatabaseException;

    /**
     * 
     * @return identifier that can be used to reconnect if the session was
     * not closed gracefully. SessionManagerSource.NullSessionId if closed
     * gracefully.
     */
    long getId();

    void ping()
    throws DatabaseException;
}
