/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.ReadGraph;



public interface ClusterControl {

	public interface ClusterState {
	}
	
    /*
     * @return The amount of fixed clusters after best effort flush
     */
    int flushClusters();
    int collectClusters(int desiredBytes);
    int gc(ReadGraph graph, int objectiveBytes);
    int gc(ReadGraph graph);
    int used();
    ClusterState getClusterState();
    void restoreClusterState(ClusterState state);
    ClusterCollectorPolicy setPolicy(ClusterCollectorPolicy newPolicy);

}
