/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;



/**
 * @author Antti Villberg
 */
public interface ClusterBuilder2 {
	
    void newCluster() throws DatabaseException;
    void selectCluster(long cluster) throws DatabaseException;
    void newCluster(int set) throws DatabaseException;
    void createClusterSet(int resource) throws DatabaseException;
	int newResource() throws DatabaseException;
	int newResource(int set) throws DatabaseException;
	int resource(Resource res) throws DatabaseException;

    void addStatement(WriteOnlyGraph graph, int subject, int predicate, int object) throws DatabaseException;
    void beginValue(int subject);
    void appendValue(int byteValue) throws DatabaseException ;
    void endValue() throws DatabaseException ;
	
    Resource resource(int subject);
    int handle(Resource r);
	
}
