/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;



/**
 * @author Antti Villberg
 */
public interface ClusterBuilder {
	
	public interface ResourceHandle {
		void addStatement(StatementHandle handle);
		void addStatement(ResourceHandle predicate, ResourceHandle object);
		void addStatement(WriteOnlyGraph graph, ResourceHandle predicate, ResourceHandle object) throws DatabaseException;
		void addValue(WriteOnlyGraph graph, byte[] value) throws DatabaseException;
		void addValue(Object value, Binding binding);
		void addValue(Object value, Serializer serializer);
		void applyPredicate(Object change);
		void applyObject(Object change);
		Resource resource(SerialisationSupport support);
	}
	
	public interface StatementHandle {
		void apply(Object change);
	}
	
	void newCluster() throws DatabaseException;
	ResourceHandle newResource() throws DatabaseException;
//	ResourceHandle newResource(ResourceHandle handle) throws DatabaseException;
	ResourceHandle resource(Resource res) throws DatabaseException;
//	StatementHandle newStatement(Resource predicate, Resource object) throws DatabaseException;
	StatementHandle newStatement(ResourceHandle predicate, ResourceHandle object) throws DatabaseException;
	
	

//	<T, I> T createMap(Class<I> clazz);
//	Set<Resource> createSet();
//	Collection<Resource> createList();
//	Collection<Statement> createStatementList();

}
