/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.request;

import org.simantics.db.exception.DatabaseException;

public interface QueryFactory {

	public <T> T readKey(QueryDeserializer deserializer) throws DatabaseException;
	public Object readValue(QueryDeserializer deserializer, Object key) throws DatabaseException;

	default void readEntry(QueryDeserializer deserializer) throws DatabaseException {
		Object key = readKey(deserializer);
		deserializer.store(key, readValue(deserializer, key));
	}

	default void read(QueryDeserializer deserializer) throws DatabaseException {
		readEntry(deserializer);
		readParents(deserializer);
	}

	default public void readParents(QueryDeserializer deserializer) throws DatabaseException {
		int ps = deserializer.readLE4();
		for(int i=0;i<ps;i++) {
			QueryFactory qf = deserializer.readFactory();
			deserializer.parent(qf.readKey(deserializer));
		}
	}

}
