/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;

import org.simantics.db.ServiceLocator;

/**
 * Thrown by {@link ServiceLocator} when requested services are unavailable.
 * 
 * @author Tuukka Lehtonen
 */
public class ServiceNotFoundException extends RuntimeDatabaseException {

    private static final long    serialVersionUID = 2454410258587204157L;

    private final ServiceLocator locator;
    private final Class<?>       clazz;

    public ServiceNotFoundException(ServiceLocator locator, Class<?> clazz, String message) {
        super(message);
        this.locator = locator;
        this.clazz = clazz;
    }

    public ServiceNotFoundException(ServiceLocator locator, Class<?> clazz) {
        this.locator = locator;
        this.clazz = clazz;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName()).append(" is not available in ").append(locator.toString());
        String msg = getMessage();
        if (msg != null)
            sb.append(" - ").append(msg);
        return sb.toString();
    }

}
