/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;


/**
 * A base class for run-time database exceptions in org.simantics.db.
 * 
 * @author Tuukka Lehtonen
 * @version 0.8
 * @see ServiceNotFoundException
 */
public class RuntimeDatabaseException extends RuntimeException {

    private static final long serialVersionUID = -3033366670555114117L;

    public RuntimeDatabaseException() {
        super();
    }

    public RuntimeDatabaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public RuntimeDatabaseException(String message) {
        super(message);
    }

    public RuntimeDatabaseException(Throwable cause) {
        super(cause);
    }

}
