/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;

import org.simantics.db.Resource;

/**
 * @author Jani Simomaa
 * @since 1.36.0
 */
public class DatatypeNotFoundException extends AssumptionException {

    private static final long serialVersionUID = -5566773896759186602L;

    public DatatypeNotFoundException(Throwable cause) {
        super(cause);
    }

    public DatatypeNotFoundException(String message, Throwable cause, Resource... rs) {
        super(message, cause, rs);
    }

    public DatatypeNotFoundException(String message, Resource... resources) {
        super(message, resources);
    }

    public DatatypeNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }

    public DatatypeNotFoundException(String message, int... args) {
        super(message, args);
    }

    public DatatypeNotFoundException(String message) {
        super(message);
    }

}
