/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.event;

import org.simantics.db.Session;
import org.simantics.db.SessionManager;

/**
 * A listener for tracking the active Sessions of a SessionManager.
 * 
 * @author Tuukka Lehtonen
 * @see Session
 * @see SessionEvent
 * @see SessionManager
 */
public interface SessionListener {

    void sessionOpened(SessionEvent e);
    void sessionException(SessionEvent e);
    void sessionClosed(SessionEvent e);

};
