/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.adaption;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;

public interface AdaptionService {

	<T,C> T adapt(ReadGraph g, Resource r, C context, Class<C> contextClass, Class<T> targetClass, boolean possible) throws DatabaseException;
	
    <T,C> void adapt(AsyncReadGraph g, Resource r, C context, Class<C> contextClass, Class<T> targetClass, boolean possible, AsyncProcedure<T> procedure);
    <T> void adaptNew(AsyncReadGraph g, Resource r, Class<T> clazz, boolean possible, AsyncProcedure<T> procedure);

    <T> void declareAdapter(Resource type, Class<T> targetClass);
    <T> void declareAdapter(Resource type, Class<T> targetClass, Class<?> contextClass);

    <T> void addAdapter(Resource type, Class<T> targetClass, Adapter<T, ?> adapter);
    <T> void addAdapter(Resource type, Class<T> targetClass, Class<?> contextClass, Adapter<T, ?> adapter);
    
    <T> void addInstanceAdapter(Resource resource, Class<T> targetClass, Adapter<T, ?> adapter);
    <T> void addInstanceAdapter(Resource resource, Class<T> targetClass, Class<?> contextClass, Adapter<T, ?> adapter);

    /**
     * Remove instance adapter to specified class for specified resource,
     * regardless of the currently installed adapter.
     * 
     * @param <T> the adaptation target type
     * @param resource the resource from which to remove the adapter
     * @param clazz the target class of the adapter to be removed
     * @return the removed adapter or <code>null</code> if no adapter was
     *         installed
     */
    <T> Adapter<T,?> removeInstanceAdapter(Resource resource, Class<T> clazz);
    <T> Adapter<T,?> removeInstanceAdapter(Resource resource, Class<T> clazz, Class<?> contextClass);

    /**
     * Remove instance adapter to specified class for specified resource
     * if the currently installed adapter matches the specified adapter.
     * 
     * @param <T> the adaptation target type
     * @param resource the resource from which to remove the adapter
     * @param clazz the target class of the adapter to be removed
     * @param adapter the adapter to remove
     */
    <T> void removeInstanceAdapter(Resource resource, Class<T> clazz, Adapter<T,?> adapter);
    <T> void removeInstanceAdapter(Resource resource, Class<T> clazz, Class<?> contextClass, Adapter<T,?> adapter);

}
