/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;


public interface VirtualGraphSource {
    
    void attach(VirtualGraphContext context);
    void getStatements(ReadGraph graph, VirtualGraphContext context, int resource) throws DatabaseException;
    void getStatements(ReadGraph graph, VirtualGraphContext context, int resource, int predicate) throws DatabaseException;
    void getValue(AsyncReadGraph graph, VirtualGraphContext context, int resource, AsyncProcedure<byte[]> value);
    
    // Option 1:
    //  
    //  Datatype getType(VirtualGraphContext context, int resource);
    //  Object getValue(VirtualGraphContext context, int resource, Binding binding);  
    //
    
    // Option 2: 
    // Variant getValue(VirtualGraphContext context, int resource);

}
