/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import java.io.IOException;

import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.event.SessionListener;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * @see Session
 * @see SessionListener
 */
public interface SessionManager {

    void addSessionListener(SessionListener listener);
    void removeSessionListener(SessionListener listener);

    SessionErrorHandler getErrorHandler();
    void setErrorHandler(SessionErrorHandler errorHandler);

    Session createSession(SessionReference sessionReference, UserAuthenticationAgent authAgent) throws DatabaseException, IOException;
    void shutdown(Session session, Throwable cause);
	Database getDatabase();

}
