/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.service.SessionMonitorSupport;

/**
 * An interface provided by clients to {@link SessionMonitorSupport} to be able
 * to receive notifications about changes in {@link Session} state variables.
 * 
 * <p>
 * The handler does not support specific notifications, it is only a general way
 * of saying to clients that something has changed.
 * 
 * @see MonitorContext
 * @see SessionMonitorSupport
 * @see SessionVariables
 */
public interface MonitorHandler {

    /**
     * Some variables have changed in the monitored session.
     * 
     * @param c a context that can be used to access the variables
     */
    void valuesChanged(MonitorContext c);

}
